using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline;
using Microsoft.Xna.Framework.Content.Pipeline.Graphics;
using Microsoft.Xna.Framework.Content.Pipeline.Processors;
using Microsoft.Xna.Framework.Content.Pipeline.Serialization.Compiler;

using TWrite = Chapitre_8_Shared.Tile;

namespace Chapitre_8_Content_Pipeline_Extension
{
    [ContentTypeWriter]
    public class TileWriter : ContentTypeWriter<TWrite>
    {
        protected override void Write(ContentWriter output, TWrite value)
        {
            output.Write(value.AssetName);

            output.Write(value.Position);
        }

        public override string GetRuntimeReader(TargetPlatform targetPlatform)
        {
            return typeof(Chapitre_8_Shared.TileReader).AssemblyQualifiedName;
        }
    }
}
